/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.animation;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;

public class AnimationDamageHitbox {
    public float[] offset = new float[]{1.2f, 0.95f, 0.0f};
    public float[] scale = new float[]{1.2f, 1.5f, 1.2f};
    public int id;

    public AnimationDamageHitbox(int i) {
        this.id = i;
    }

    public void clear() {
        this.offset[0] = 1.2f;
        this.offset[1] = 0.95f;
        this.offset[2] = 0.0f;
        for (int i = 0; i < 3; ++i) {
            this.scale[i] = 1.0f;
        }
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", this.id);
        NBTTagList listO = new NBTTagList();
        NBTTagList listS = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            listO.func_74742_a((NBTBase)new NBTTagFloat(this.offset[i]));
            listS.func_74742_a((NBTBase)new NBTTagFloat(this.scale[i]));
        }
        compound.func_74782_a("Offset", (NBTBase)listO);
        compound.func_74782_a("Scale", (NBTBase)listS);
        return compound;
    }

    public AnimationDamageHitbox(NBTTagCompound compound, int i) {
        this.id = i;
        NBTTagList listO = compound.func_150295_c("Offset", 5);
        for (int j = 0; j < 3 && j < listO.func_74745_c(); ++j) {
            this.offset[j] = listO.func_150308_e(j);
        }
        NBTTagList listS = compound.func_150295_c("Scale", 5);
        for (int j = 0; j < 3 && j < listS.func_74745_c(); ++j) {
            this.scale[j] = listS.func_150308_e(j);
        }
    }

    public AxisAlignedBB getScaledDamageHitbox(EntityLivingBase entity) {
        AxisAlignedBB aabb = new AxisAlignedBB(-0.5 * (double)this.scale[0], -0.5 * (double)this.scale[1], -0.5 * (double)this.scale[2], 0.5 * (double)this.scale[0], 0.5 * (double)this.scale[1], 0.5 * (double)this.scale[2]).func_72317_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double radYaw = Math.toRadians(entity.field_70177_z) + (double)this.offset[2];
        return aabb.func_72317_d(Math.sin(radYaw) * (double)(-this.offset[0]), (double)this.offset[1], Math.cos(radYaw) * (double)this.offset[0]);
    }

    public String getKey() {
        AxisAlignedBB damageHitbox = new AxisAlignedBB(-0.5 * (double)this.scale[0], -0.5 * (double)this.scale[1], -0.5 * (double)this.scale[2], 0.5 * (double)this.scale[0], 0.5 * (double)this.scale[1], 0.5 * (double)this.scale[2]);
        char c = '\u00a7';
        return c + "7ID:" + c + "r" + (this.id + 1) + c + "7; d:" + c + "a" + (double)Math.round((double)this.offset[0] * 10.0) / 10.0 + c + "7, h:" + c + "a" + (double)Math.round((double)this.offset[1] * 10.0) / 10.0 + c + "7, w:" + c + "a" + (double)Math.round((double)this.offset[2] * 10.0) / 10.0 + c + "7";
    }
}

